#ifdef GL_ES
    precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

void main() {
    // below is a freely customizable scanline shader that is applied to the game at the end of each frame (on top of everything)
    // feel free to finetune values and effects to suit your mod better
    // if you want to change or add new effects entirely but dont know how to code here,
    // i recommend pasting this file into grok AI or chatgpt and telling it to "Change this OpenGL GLSL fragment shader and add ____ effect"!
    // good luck!

    // Base texture color
    vec4 baseColor = texture2D(u_texture, v_texCoords) * v_color;
    
    // Vignette effect
    float vignette = 1.0 - dot(v_texCoords - 0.5, v_texCoords - 0.5) * 0.65;
    vignette = clamp(vignette, 0.3, 1.0);
   
    // Additive gradient effect (light blue #00FFFF)
    vec3 gradientColor = vec3(0.8, 0.0, 1.0); // RGB for #00FFFF
    float gradientStrength = 0.22; // Adjust this to control gradient intensity
    float gradient = 1.0 - v_texCoords.y; // Linear gradient from top (0.0) to bottom (1.0)
    vec3 gradientEffect = gradientColor * gradient * gradientStrength;
    
    // Combine effects
    vec4 finalColor = baseColor;
    finalColor.rgb *= vignette;
    finalColor.rgb += gradientEffect; // Additive gradient
    finalColor.a = 1.0;

    gl_FragColor = finalColor;
}